<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@lang('emails.preferred_timings.title')</title>
</head>

<body style="margin:0; padding:0; font-family: Arial, sans-serif; background-color:#ffffff;">
    <table align="center" width="100%" cellpadding="0" cellspacing="0" border="0" style="max-width:700px;">
        <!-- Email Banner -->
         <tr>
            <td align="center" valign="top">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" valign="top" style=" width:100%; height:60px;">
                    
                    <!-- Spacer to push logo down -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" height="27">
                      <tr>
                        <td></td>
                      </tr>
                    </table>

                    <!-- Logo -->
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td align="center">
                          <img src="{{ asset('frontend/images/logo.png')}}" width="240" style="max-width:240px; width:100%; display:block; border:0;" alt="Logo">
                        </td>
                      </tr>
                    </table>

                  </td>
                </tr>
              </table>
            </td>
          </tr>

        <!-- Email Body -->
        <tr>
            <td style="padding:50px 30px; font-family:Arial, sans-serif;">
                <h2 style="font-family:Arial, sans-serif; font-weight:700; font-size:24px; line-height:100%; text-align:center; margin:0;">
                    @lang('emails.preferred_timings.booking_preferred_timings')
                </h2>
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; text-align:center; margin:30px 0 30px 0; color:#111111;">
                    @lang('emails.preferred_timings.dear', ['name' => $userDetails->first_name . ' ' . $userDetails->last_name])<br>
                    @lang('emails.preferred_timings.noted_timings_message', ['invoice_number' => $booking->invoice_number])
                </p>
                <p style="font-family: Arial; font-weight: 400; font-size: 16px; line-height: 24px; color: #111111;">
                    @lang('emails.preferred_timings.thank_you_patience')
                </p>

                <table border="0" cellspacing="0" cellpadding="0" align="center"></table>

                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('emails.preferred_timings.summary_of_booking'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.booking_number'):
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $booking->invoice_number }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.pickup_datetime')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} | 
                            {{ $item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '' }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.dropoff_datetime')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} | 
                            {{ $item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '' }}
                        </td>
                    </tr>
                </table>

                <!-- Booking Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('emails.preferred_timings.booking_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.booking_id')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #{{ str_pad($booking->id, 6, '0', STR_PAD_LEFT) }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.booking_date')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $booking->created_at->format('d.m.Y') }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.booking_status')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ ucfirst($booking->status) }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.payment_method')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                          
                            {{ str_contains(strtolower($booking->payment_method), 'card') ? 'Karte' : ucfirst($booking->payment_method) }}

                        </td>
                    </tr>
                    @foreach($bookingItems as $item)
                    @if(!$item->related_item)
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.rental_period')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} - {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.rental_days')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $item->days }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.pickup_location')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">


                              {{ $vendor->street ?? $admin->address ?? '' }}<br>
                             {{ $vendor->zip_code ?? $admin->zip_code ?? '' }} {{ $vendor->city ?? $admin->city ?? '' }} <br>
                            {{ $vendor->country ?? $admin->state ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.pickup_datetime')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y') }} | 
                            {{ $item->pickup_time ? \Carbon\Carbon::parse($item->pickup_time)->format('H:i') : '' }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.dropoff_datetime')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y') }} | 
                            {{ $item->dropoff_time ? \Carbon\Carbon::parse($item->dropoff_time)->format('H:i') : '' }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.carrier_included')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            @if($item->is_carrier_included)
                                @lang('emails.preferred_timings.length'): {{ $item->carrier_length ?? 'N/A' }}<br>
                                @lang('emails.preferred_timings.foot_kit'): {{ $item->carrier_foot_kit ?? 'N/A' }}<br>
                                @lang('emails.preferred_timings.foot'): {{ $item->carrier_foot ?? 'N/A' }}
                            @else
                                @lang('emails.preferred_timings.no')
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.insurance')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $item->is_insured ? __('emails.preferred_timings.included') : __('emails.preferred_timings.not_included') }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.mounting_services')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            @lang('emails.preferred_timings.included')
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.cleaning_service')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            @lang('emails.preferred_timings.included')
                        </td>
                    </tr>
                    @endif
                    @endforeach
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.coupon_discount')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ number_format($booking->discount ?? 0, 2) }}€
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.subtotal')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ number_format($booking->subtotal, 2, ',', '.') }} €
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.tax')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ number_format($booking->tax, 2) }}€
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.total')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ number_format($booking->total, 2, ',', '.') }} €
                        </td>
                    </tr>
                </table>

                <!-- Product Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('emails.preferred_timings.product_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    @foreach($bookingItems as $item)
                    @if(!$item->related_item)
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.product_id')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #{{ str_pad($item->product_id, 6, '0', STR_PAD_LEFT) }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.product_name')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $item->product_name }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.quantity')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            1
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.size_variation')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $item->size }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.color')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $item->color }}
                        </td>
                    </tr>
                    @endif
                    @endforeach
                </table>

                <!-- Car Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('emails.preferred_timings.car_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    @foreach($bookingItems as $item)
                    @if(!$item->related_item)
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.brand')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $item->car_name }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.year')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $item->car_year }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.model')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $item->model }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.trailer_hitch')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $item->trailer_hitch ? __('emails.preferred_timings.yes') : __('emails.preferred_timings.no') }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.roof_type')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $item->roof_type }}
                        </td>
                    </tr>
                    @endif
                    @endforeach
                </table>

                <!-- Customer Details -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#111111; margin:30px 0 10px 0;">
                    <b>@lang('emails.preferred_timings.customer_details'):</b>
                </p>
                <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #5BC0DE; table-layout: fixed; border-collapse:collapse; font-family:Arial, sans-serif; font-size:16px; line-height:100%;" border="0">
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.customer_id')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            #{{ str_pad($userDetails->user_id, 6, '0', STR_PAD_LEFT) }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.customer_name')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $userDetails->first_name }} {{ $userDetails->last_name }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.address')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $userDetails->address }}, <br>{{ $userDetails->zip }}  {{ $userDetails->city }}, <br> {{ $userDetails->country }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.email_address')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $userDetails->email }}
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px; border-radius:5px 0 0 5px;">
                            @lang('emails.preferred_timings.phone_number')
                        </td>
                        <td bgcolor="#c7edf7" style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px; border-radius:0 5px 5px 0;">
                            {{ $userDetails->phone }}
                        </td>
                    </tr>
                    <tr>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#111111; padding:12px 30px;">
                            @lang('emails.preferred_timings.invoice_number')
                        </td>
                        <td style="width:50%; font-family:Arial; font-weight:400; color:#666666; padding:12px 30px;">
                            {{ $booking->invoice_number}}
                        </td>
                    </tr>
                </table>

                <!-- Closing Paragraph -->
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:16px; line-height:24px; color:#000000; margin-top:30px;">
                    @lang('emails.preferred_timings.closing_message')<br><br>
                    @lang('emails.preferred_timings.best_regards')<br>
                    @lang('emails.preferred_timings.team_signature')
                </p>
            </td>
        </tr>

        <!-- Footer -->
         <tr>
            <td bgcolor="#111111" style="padding:31px 45px 0px 45px; border-bottom:unset;" align="center">
                <img src="{{ asset('frontend/images/logo.png')}}" alt="" width="220" style="display:block; margin:0 auto;">
               

                <!-- Social Section -->
                <table border="0" cellspacing="0" cellpadding="0" align="center">
                    <tr>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0;">
                            <img src="{{ asset('frontend/images/Message.png')}}" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">cs@dachboxit.de</p>
                        </td>
                        <td align="center" valign="top" style="padding:0 15px; margin: 15px 0; ">
                            <img src="{{ asset('frontend/images/Mobile.png')}}" width="20" height="20" style="display:block; margin:0 auto;">
                            <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:10px 0 0 0;">+4915172876293</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">
                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin: 0px 0 20px 0;">
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/gdpr" style="color:#ffffff; text-decoration:none; margin:15px 5px;">
                        {{ __('messages.payment_link_email.privacy_policy') }}
                    </a>
                    |
                    <a href="http://49.249.236.30:3131/dachboxmiete-phase-2/public/term-condition" style="color:#ffffff; text-decoration:none; margin:0 5px;">
                        {{ __('messages.payment_link_email.terms_conditions') }}
                    </a>
                </p>
            </td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="height: 20px; background: #111111;"></td>
        </tr>
        <tr>
            <td bgcolor="#111111" style="background: #111111;">

                <p style="font-family:Arial; font-size:14px; line-height:24px; text-align:center; color:#ffffff; margin:0;">
                    Rerent Esperantostrasse 10, 70197 Stuttgart, Germany<br>Usatzsteuer-ID: DE300067568
                </p>
            </td>

        </tr>
        <!-- Copyright -->
        <tr>
            <td bgcolor="#111111" style="padding:15px 30px; text-align:center;">
                <p style="font-family:Arial, sans-serif; font-weight:400; font-size:14px; line-height:24px; color:#fff; margin:0;">
                    @lang('emails.preferred_timings.copyright', ['year' => date('Y')])
                </p>
            </td>
        </tr>
    </table>
</body>
</html>